# 2018-May-08. 
$scriptPath = Split-Path -parent $MyInvocation.MyCommand.Definition; 
. ($scriptPath + "\psFunctions.ps1");     # Adding script with reusable functions
. ($scriptPath + "\psSetVariables.ps1");  # Adding script to assign values to common variables

$logFile        = $scriptPath + "\Log\" + $MyInvocation.MyCommand.Name.Replace(".ps1",".txt"); 
(Get-Date).ToString("HH:mm:ss") + " --- Starting script " + $MyInvocation.MyCommand.Name | Out-File $logFile -Encoding OEM; # starting logging to file.
$logSummary = (Get-Date).ToString("HH:mm:ss") + " Script: MakeAllFiles".PadRight(28);
$currExchIDFile = $currExchIDFolder + "YahooCurrExchIntraday.txt";

$includeArchiveFlag = $false; $includeArchiveValue = ($config | Select-Object -Index(($config.IndexOf("<IncludeQuoteArchiveFolder>"))+1)).Replace("</IncludeQuoteArchiveFolder>",""); # Getting IncludeArchive value
if ($includeArchiveValue -ne $null) {if ($includeArchiveValue.Trim().ToLower() -eq "yes") {$includeArchiveFlag = $true;}} 
$eol="`r`n";

# #######################################################################################
# First loading all factors (History, Intraday and Dividends into array for fast access
# #######################################################################################
# ============ Building array of factors for History,Intraday (quotes) and dividends. $sFH - array of symbols with historical factors, $sFHF - array of factors for each symbol in $sFH, etc.
$sFH = @(); $sFHF = @(); $sFI = @(); $sFIF = @(); $sDI = @(); $sDIF = @();
$listStart = $config.IndexOf("<Yahoo>"); $listEnd = $config.IndexOf("</Yahoo>");  #Symbol,MinDate,MaxDate,IntraDayFlag[Y|N],[DividendFlag[Y|N],FactorHistory,FactorIntraDay,FactorDividend
if (!($listStart -eq -1 -or $listEnd -eq -1 -or $listStart+1 -ge $listEnd)) {
    $list = @($config | Select-Object -Index(($listStart+1)..($listEnd-1)));
    ForEach($line in $list) { $a = $line.Split(",");
        if($a[5] -ne "" -and $a[5] -ne $null) {$sFH += ,$a[0]; $sFHF += ,$a[5];} # Building arrays for FactorHistory
        if($a[6] -ne "" -and $a[6] -ne $null) {$sFI += ,$a[0]; $sFIF += ,$a[6];} # Building arrays for FactorIntraday
        if($a[7] -ne "" -and $a[7] -ne $null) {$sDI += ,$a[0]; $sDIF += ,$a[7];} # Building arrays for DividendFactor
}   }

$listStart = $config.IndexOf("<Google>"); $listEnd = $config.IndexOf("</Google>");  #Symbol,MinDate,MaxDate,IntraDayFlag[Y|N],[DividendFlag[Y|N],FactorHistory,FactorIntraDay,FactorDividend
if (!($listStart -eq -1 -or $listEnd -eq -1 -or $listStart+1 -ge $listEnd)) {
    $list = @($config | Select-Object -Index(($listStart+1)..($listEnd-1)));
    ForEach($line in $list) { $a = $line.Split(",");
        if($a[5] -ne "" -and $a[5] -ne $null) {$sFH += ,$a[0]; $sFHF += ,$a[5];} # Building arrays for FactorHistory
        if($a[6] -ne "" -and $a[6] -ne $null) {$sFI += ,$a[0]; $sFIF += ,$a[6];} # Building arrays for FactorIntraday
        if($a[7] -ne "" -and $a[7] -ne $null) {$sDI += ,$a[0]; $sDIF += ,$a[7];} # Building arrays for DividendFactor
}   }

$listStart = $config.IndexOf("<GoogleWeb>"); $listEnd = $config.IndexOf("</GoogleWeb>");  #Symbol,MinDate,MaxDate,IntraDayFlag[Y|N],[DividendFlag[Y|N],FactorHistory,FactorIntraDay,FactorDividend
if (!($listStart -eq -1 -or $listEnd -eq -1 -or $listStart+1 -ge $listEnd)) {
    $list = @($config | Select-Object -Index(($listStart+1)..($listEnd-1)));
    ForEach($line in $list) { $a = $line.Split(",");
        if($a[5] -ne "" -and $a[5] -ne $null) {$sFH += ,$a[0]; $sFHF += ,$a[5];} # Building arrays for FactorHistory
        if($a[6] -ne "" -and $a[6] -ne $null) {$sFI += ,$a[0]; $sFIF += ,$a[6];} # Building arrays for FactorIntraday
        if($a[7] -ne "" -and $a[7] -ne $null) {$sDI += ,$a[0]; $sDIF += ,$a[7];} # Building arrays for DividendFactor
}   }

$listStart = $config.IndexOf("<Stooq>"); $listEnd = $config.IndexOf("</Stooq>");  #Symbol,MinDate,MaxDate,IntraDayFlag[Y|N],[DividendFlag[Y|N],FactorHistory,FactorIntraDay,FactorDividend
if (!($listStart -eq -1 -or $listEnd -eq -1 -or $listStart+1 -ge $listEnd)) {
    $list = @($config | Select-Object -Index(($listStart+1)..($listEnd-1)));
    ForEach($line in $list) { $a = $line.Split(",");
        if($a[5] -ne "" -and $a[5] -ne $null) {$sFH += ,$a[0]; $sFHF += ,$a[5];} # Building arrays for FactorHistory
        if($a[6] -ne "" -and $a[6] -ne $null) {$sFI += ,$a[0]; $sFIF += ,$a[6];} # Building arrays for FactorIntraday
        if($a[7] -ne "" -and $a[7] -ne $null) {$sDI += ,$a[0]; $sDIF += ,$a[7];} # Building arrays for DividendFactor
}   }

$listStart = $config.IndexOf("<AlphaVantage>"); $listEnd = $config.IndexOf("</AlphaVantage>");  #Symbol,MinDate,MaxDate,IntraDayFlag[Y|N],[DividendFlag[Y|N],FactorHistory,FactorIntraDay,FactorDividend
if (!($listStart -eq -1 -or $listEnd -eq -1 -or $listStart+1 -ge $listEnd)) {
    $list = @($config | Select-Object -Index(($listStart+1)..($listEnd-1)));
    ForEach($line in $list) { $a = $line.Split(",");
        if($a[5] -ne "" -and $a[5] -ne $null) {$sFH += ,$a[0]; $sFHF += ,$a[5];} # Building arrays for FactorHistory
        if($a[6] -ne "" -and $a[6] -ne $null) {$sFI += ,$a[0]; $sFIF += ,$a[6];} # Building arrays for FactorIntraday
        if($a[7] -ne "" -and $a[7] -ne $null) {$sDI += ,$a[0]; $sDIF += ,$a[7];} # Building arrays for DividendFactor
}   }

# #######################################################################################
# #######################################################################################
# #######################################################################################


# #######################################################################################
# ######################## Creating Currency Exchange file.
# #######################################################################################
$str=(Get-Date).ToString("HH:mm:ss") + " Starting creating file CurrencyConv.csv."; $str | Out-File $logFile -Encoding OEM -Append; if ($verbose) {$str};
$outFile = $psDataFolder + "\CurrencyConv.csv"; $fileCount = 0; $recCount = 0;
"Date,ExchRate,CurrencyFrom,CurrencyTo".Replace(",", $colSep).Replace(".",$decSep) | Out-File $outFile -Encoding OEM;
("$minDate,1.0000000001,N/A,N/A").Replace(",", $colSep).Replace(".",$decSep) | Out-File $outFile -Encoding OEM -Append; 
(Get-ChildItem $currExchFolder | where {$_.extension -eq ".txt"}) | ?{$fc=@(Get-Content -Path $_.FullName); $fileCount+=1; $recCount+=$fc.Count; $fc.Replace(",", $colSep).Replace(".",$decSep) | Out-file $outFile -Encoding OEM -Append };
$currExchFolder = $currExchFolder + "\Manual";
if (Test-Path -Path $currExchFolder) { # if Manual subfolder exists, then include all txt files form that subfolder
    (Get-ChildItem $currExchFolder | where {$_.extension -eq ".txt"}) | ?{$fc=@(Get-Content -Path $_.FullName | ? {$_.Trim() -ne ""}); $fileCount+=1; $recCount+=$fc.Count; $fc.Replace(",", $colSep).Replace(".",$decSep) | Out-file $outFile -Encoding OEM -Append };
}

# ######################## Adding intraday exchange rates
$fl = @(Get-ChildItem $currExchIDFolder -Recurse | where {$_.extension -eq ".txt" -and (($_.BaseName -like "*CurrExch*"))}); 
ForEach($f in $fl) {(Get-Content -Path $f.FullName).Replace(",", $colSep).Replace(".",$decSep) | Out-file $outFile -Encoding OEM -Append;}
#if (Test-Path $currExchIDFile) {(Get-Content -Path $currExchIDFile).Replace(",", $colSep).Replace(".",$decSep) | Out-file $outFile -Encoding OEM -Append;} # Adding intraday quotes if file found

$str=(Get-Date).ToString("HH:mm:ss") + " Finished creating file CurrencyConv.csv. Source file count: " + $fileCount.ToString().PadLeft(3) + ". Record count: $recCount.";
$str | Out-File $logFile -Encoding OEM -Append; if ($verbose) {$str};
# #######################################################################################

# #######################################################################################
# Applying currency factors
# #######################################################################################
#$listStart = $config.IndexOf("<CurrencyFactor>"); $listEnd = $config.IndexOf("</CurrencyFactor>");  #Symbol,MinDate,MaxDate,IntraDayFlag[Y|N],[DividendFlag[Y|N],FactorHistory,FactorIntraDay,FactorDividend
#if (!($listStart -eq -1 -or $listEnd -eq -1 -or $listStart+1 -ge $listEnd)) {
#    $confList = @($config | Select-Object -Index(($listStart+1)..($listEnd-1)));
#    $currFile = Get-Content -Path $outFile;
#    $currFileNew = "";
#    ForEach($line in $confList) {$a = $line.Split(","); $currFrom=$a[0]; $currTo=$a[1]; $factor=[double]$a[2];                   $currFrom + " - " + $currTo + " -> " + $factor;
#        ForEach($l in $currFile) {
#            $lSplit = $l.split($colSep); $cFrom = $lSplit[0]; $cTo=$lSplit[1]; $cValue=$lSplit[2]; $cValueNum = [Double]$cValue;
#            if($cFrom.ToLower() -eq $currFrom.ToLower() -and -$cTo.ToLower() -eq $currTo.ToLower()) {
#                $currFileNew += $cFrom + $colSep + $cTo + ($colSep + $cValueNum * $factor).ToString("##########0.0#######", $culture).Replace(".",$decSep) + $eol; 
#            }
#            else {$currFileNew += $cFrom + $colSep + $cTo + $colSep + $cValue + $eol;}
#        }
#}   }
#exit(1);



# #######################################################################################
# ========================== Creating dividends file
# #######################################################################################
$outFile = $psDataFolder + "\Dividends.csv"; $fileCount = 0; $recCount = 0; $eol="`r`n";
$df = "PayDate,DividendPerShare,Symbol".Replace(",", $colSep).Replace(".",$decSep) + $eol; # File should always have at least a header
$df += (("$minDate,0.0000000001,* Cash").Replace(",", $colSep).Replace(".",$decSep) + $eol); # Adding second line with todays date to enforce data types in Excel.Tiny amount will not be visible
$fl = (Get-ChildItem $divFolder | where {$_.extension -eq ".txt"}); if ($fl.count -eq 1) {$fl = ,@($fl)}; # Reading all *.txt files from dividends data folder. If 1 record returned, convert to array so we can add other folders
if (Test-Path ($divFolder+"\Manual")) {
    $fl += (Get-ChildItem ($divFolder+"\Manual") | where {$_.extension -eq ".txt"}); # Including "\Manual" subfolder
}
ForEach($f in $fl) { # working on each file ($f)
    $fc=@(Get-Content -Path $f.FullName | ? {$_.Trim() -ne ""}); if ($fc.Count -le 0) {continue;} $fileCount+=1; $recCount+=$fc.Count; $symbol = $fc.Split(",")[2];   # Get file content into $fc
    if ($sDI.IndexOf($symbol) -ne -1) { $factor = [double]$sDIF[$sDI.IndexOf($symbol)]; # if symbol located in array, then on dividend amount we need to apply factor
          ForEach($dl in $fc) {$d = $dl.Split(","); $df += ($d[0] + $colSep + (([double]$d[1]) * $factor).ToString("########0.0######", $culture).Replace(".",$decSep) + $colSep + $d[2] + $eol);} #output each row with factor applied
    }
    else {ForEach($dl in $fc) {$d = $dl.Split(","); $df += ($d[0] + $colSep + $d[1].Replace(".",$decSep) + $colSep + $d[2] + $eol); } } #output each row with necessary replacements
}
$df | Out-File $outFile -Encoding OEM; # output to the file
$str=(Get-Date).ToString("HH:mm:ss") + " Finished creating file    Dividends.csv. Source file count: " + $fileCount.ToString().PadLeft(3) + ". Record count: $recCount.";
$str | Out-File $logFile -Encoding OEM -Append; if ($verbose) {$str};
# #######################################################################################
$divfile = (gc $outFile) | ? {$_.trim() -ne "" };
Start-Sleep -Milliseconds 50; 
$divfile | set-content $outFile  # Removing empty lines from dividends file
# #######################################################################################

# #######################################################################################
# ######################## Creating Quotes file
# #######################################################################################
#(Get-Date).ToString("HH:mm:ss") 
$outFile = $psDataFolder + "\Quotes.csv"; $fileCount = 0; $recCount = 0; $eol="`r`n";
$qf="Date,Close,Symbol`r`n".Replace(",", $colSep).Replace(".",$decSep);
$qf+=("$minDate,1.0000000001,* Cash").Replace(",", $colSep).Replace(".",$decSep); 
$qf | Out-File $outFile -Encoding OEM; 
$fl = @(Get-ChildItem $quotesFolder -Recurse | where {$_.extension -eq ".txt" -and (!($_.BaseName -like "*_Archive") -or $includeArchiveFlag)}); #if ($fl.count -eq 1) {$fl = ,@($fl)};
ForEach($f in $fl) {
    $fc=@(Get-Content -Path $f.FullName | ? {$_.Trim() -ne ""}); if ($fc.Count -le 0) {continue;} $fileCount+=1; $recCount+=$fc.Count; $symbol = $fc.Split(",")[2];   # Get file content into $fc
    $qf="";
    if ($sFH.IndexOf($symbol) -ne -1) { $factor = [double]$sFHF[$sFH.IndexOf($symbol)]; # if symbol located in array, then on amount we need to apply factor
        ForEach($dl in $fc) {$d = $dl.Split(","); $qf+=($d[0] + $colSep + (([double]$d[1]) * $factor).ToString("#########0.0#####", $culture).Replace(".",$decSep) + $colSep + $d[2] + $eol);} #output each row with factor applied
    }
    else {ForEach($dl in $fc) {$d = $dl.Split(","); $qf+=($d[0] + $colSep + $d[1].Replace(".",$decSep) + $colSep + $d[2] + $eol);} }
    #else {$fc.Replace(",", $colSep).Replace(".",$decSep) | Out-file $outFile -Encoding OEM -Append;} # just dump file content into final file without adjusting amounts
    if ($qf.trim() -ne "" -and $qf.Length -gt 2) {$qf = $qf.Substring(0, $qf.Length - 2); $qf | Out-File $outFile -Encoding OEM -Append;}
}
$str=(Get-Date).ToString("HH:mm:ss") + " Finished creating file       Quotes.csv. Source file count: " + $fileCount.ToString().PadLeft(3) + ". Record count: $recCount.";
$str | Out-File $logFile -Encoding OEM -Append; if ($verbose) {$str};
#(Get-Date).ToString("HH:mm:ss") 
# #######################################################################################


# #######################################################################################
# ######################## Adding intraday quotes
# #######################################################################################
$outFile = $psDataFolder + "\Quotes.csv"; $fileCount = 0; $recCount = 0; $qf=""; 
$fl = @(Get-ChildItem $quotesIDFolder -Recurse | where {$_.extension -eq ".txt" -and (!($_.BaseName -like "*CurrExch*"))}); 
ForEach($f in $fl) {
    $fc = @(Get-Content -Path $f.FullName);
    ForEach($l in $fc) {
        if ($l.trim() -ne "") {
            $ls = $l.split(","); $symbol = $ls[2];
            if ($sFI.IndexOf($symbol) -ne -1) { $factor = [double]$sFIF[$sFI.IndexOf($symbol)]; # if symbol located in array, then on amount we need to apply factor
                $qf+=($ls[0] + $colSep + (([double]$ls[1]) * $factor).ToString("##########0.0#####", $culture).Replace(".",$decSep) + $colSep + $ls[2] + $eol);
            }
            else {$qf+=($ls[0] + $colSep + $ls[1].Replace(".",$decSep) + $colSep + $ls[2] + $eol);}
        }
    }
}
$qf | Out-file $outFile -Encoding OEM -Append; # appending to existing quotes file
# #######################################################################################
$outFile2 = $psDataFolder + "\Quotes2.csv"; if (Test-Path -Path $outFile2) {Remove-Item -path $outFile2};
Rename-Item -Path $outFile -NewName "Quotes2.csv";
(gc $outFile2) | ? {$_.trim() -ne "" } | set-content $outFile  # Removing empty lines from quotes file
if (Test-Path -Path $outFile2) {Remove-Item -path $outFile2};
# #######################################################################################


# #######################################################################################
# ######################## Creating file schema.ini if column separator is TAB
# #######################################################################################
    $schemaFile =  "[CurrencyConv.csv]`r`nFormat=TabDelimited`r`nTextDelimiter=none`r`nDateTimeFormat=yyyy-mm-dd`r`ncol1=Date DateTime`r`ncol2=ExchRate Double`r`ncol3=CurrencyFrom Text`r`ncol4=CurrencyTo Text`r`n`r`n"
    $schemaFile += "[Dates.csv]`r`nFormat=TabDelimited`r`nTextDelimiter=none`r`nDateTimeFormat=yyyy-mm-dd`r`n`r`n"
    $schemaFile += "[Dividends.csv]`r`nFormat=TabDelimited`r`nTextDelimiter=none`r`nDateTimeFormat=yyyy-mm-dd`r`ncol1=PayDate DateTime`r`ncol2=DividendPerShare Double`r`ncol3=Symbol Text`r`n`r`n"
    $schemaFile += "[Quotes.csv]`r`nFormat=TabDelimited`r`nTextDelimiter=none`r`nDateTimeFormat=yyyy-mm-dd`r`ncol1=Date DateTime`r`ncol2=Close Double`r`ncol3=Symbol Text`r`n`r`n"
    $schemaFile += "[Config.csv]`r`nFormat=TabDelimited`r`nTextDelimiter=none`r`nDateTimeFormat=yyyy-mm-dd`r`ncol1=MinDate DateTime`r`ncol2=TrackCash Text`r`ncol3=RefreshTime Text`r`n`r`n"
    $schemaFile += "[ReportCurrency.csv]`r`nFormat=TabDelimited`r`nTextDelimiter=none`r`nDateTimeFormat=yyyy-mm-dd`r`ncol1=ReportCurrency Text`r`ncol2=CurrencyID Short`r`n`r`n"
    $schemaFile += "[Account.csv]`r`nFormat=TabDelimited`r`nTextDelimiter=none`r`nDateTimeFormat=yyyy-mm-dd`r`ncol1=Account Text`r`ncol2=Portfolio Text`r`ncol3=Tax Text`r`ncol4=Currency Text`r`ncol5=Active Text`r`ncol6=AccountGroup1 Text`r`ncol7=AccountGroup2 Text`r`ncol8=AccountGroup3 Text`r`n`r`n"
    $schemaFile += "[Allocation.csv]`r`nFormat=TabDelimited`r`nTextDelimiter=none`r`nDateTimeFormat=yyyy-mm-dd`r`ncol1=Allocation Text`r`ncol2=TargetPercent Double`r`ncol3=Index Text`r`n`r`n"
    $schemaFile += "[Symbol.csv]`r`nFormat=TabDelimited`r`nTextDelimiter=none`r`nDateTimeFormat=yyyy-mm-dd`r`ncol1=Symbol Text`r`ncol2=SymbolName Text`r`ncol3=Currency Text`r`ncol4=MER Double`r`ncol5=Allocation Text`r`ncol6=SymbolGroup1 Text`r`ncol7=SymbolGroup2 Text`r`ncol8=SymbolGroup3 Text`r`ncol9=Region Text`r`ncol10=CurrencyBase Text`r`n`r`n"
    $schemaFile += "[SymbolSector.csv]`r`nFormat=TabDelimited`r`nTextDelimiter=none`r`nDateTimeFormat=yyyy-mm-dd`r`ncol1=Symbol Text`r`ncol2=Sector Text`r`ncol3=Percent Double`r`ncol4=Sensitivity Text`r`n`r`n"
    $schemaFile += "[SymbolAllocation.csv]`r`nFormat=TabDelimited`r`nTextDelimiter=none`r`nDateTimeFormat=yyyy-mm-dd`r`ncol1=Symbol Text`r`ncol2=Allocation Text`r`ncol3=Percent Double`r`n`r`n"
    $schemaFile += "[TransType.csv]`r`nFormat=TabDelimited`r`nTextDelimiter=none`r`nDateTimeFormat=yyyy-mm-dd`r`ncol1=TransType Text`r`ncol2=IgnoreQtyFlag Short`r`ncol3=TransFeeSign Short`r`ncol4=CashAmntSign Short`r`ncol5=BookValueSign Short`r`ncol6=QtySign Short`r`ncol7=DistribReturnOfCapitalFlag Short`r`ncol8=DistribCapGainReinvstdFlag Short`r`ncol9=DividendFlag Short`r`ncol10=DepositTransSign Short`r`ncol11=CashImpactSign Short`r`ncol12=SellFlag Short`r`ncol13=WithholdingTaxFlag Short`r`ncol14=FeeFlag Short`r`ncol15=ExternalImpactSymbolSign Short`r`ncol16=ExternalImpactPortfolioSign Short`r`ncol17=ExternalImpactPortfolioSign2 Short`r`ncol18=CashFlag Short`r`ncol19=ExchRateFlag Short`r`ncol20=ShowForSalesReport Text`r`ncol21=TransTypeGroup Text`r`n`r`n"
    $schemaFile += "[Transactions.csv]`r`nFormat=TabDelimited`r`nTextDelimiter=none`r`nDateTimeFormat=yyyy-mm-dd`r`ncol1=Account Text`r`ncol2=Date DateTime`r`ncol3=TransType Text`r`ncol4=TransSubType Text`r`ncol5=Symbol Text`r`ncol6=Qty double`r`ncol7=Price double`r`ncol8=Fee double`r`ncol9=ExchRate double`r`ncol10=CostBasisOverride double`r`ncol11=ExchRateRpt1Override double`r`ncol12=ExchRateRpt2Override double`r`ncol13=ExchRateRpt3Override double`r`ncol14=TransID Short`r`ncol15=CostBasisImpact double`r`n`r`n"
    $schemaFile += "[CompareTo.csv]`r`nFormat=TabDelimited`r`nTextDelimiter=none`r`nDateTimeFormat=yyyy-mm-dd`r`ncol1=ID Text`r`ncol2=CompareTo Text`r`ncol3=Symbol Text`r`ncol4=AnnlAdj% Double`r`n`r`n"
    $schemaFile += "[Report.csv]`r`nFormat=TabDelimited`r`nTextDelimiter=none`r`nDateTimeFormat=yyyy-mm-dd`r`ncol1=Report Text`r`n`r`n`r`n"
    $schemaFile | Out-file ($psDataFolder+"\schema.ini") -Encoding OEM;

    #`r`nTextDelimiter=none
# #######################################################################################
# ######################## Symbol rename for Quotes.csv and Dividends.csv files
# #######################################################################################
$qFileName = $psDataFolder + "\Quotes.csv"; $dFileName = $psDataFolder + "\Dividends.csv"; $renameCount = 0;
if ((Test-Path $qFileName) -and (Test-Path $dFileName)) {
    $listStart = $config.IndexOf("<SymbolRename>"); $listEnd = $config.IndexOf("</SymbolRename>");  
    if (!($listStart -eq -1 -or $listEnd -eq -1 -or $listStart+1 -ge $listEnd)) {
        $qFile = @(Get-Content -Path $qFileName); $dFile = @(Get-Content -Path $dFileName);
        $list = @($config | Select-Object -Index(($listStart+1)..($listEnd-1)));
        ForEach($line in $list) { 
            $a = $line.Split(",");
            if($a[0] -ne "" -and $a[0] -ne $null -and $a[1] -ne "" -and $a[1] -ne $null) {
                $oldSymb = $colSep + $a[0].Replace("^","\^")+"$"; $newSymb = $colSep + $a[1]; $renameCount++; # adding $ to end to specify that change can be done just at the end of the line.
                $qFile = $qFile -replace $oldSymb, $newSymb;
                $dFile = $dFile -replace $oldSymb, $newSymb;
            } #if
        } #ForEach
        $qFile | Out-file $qFileName -Encoding OEM -Force;  
        $dFile | Out-file $dFileName -Encoding OEM -Force;  
    }
}

$duration = (NEW-TIMESPAN -Start $startTime -End (Get-Date)).TotalSeconds.ToString("#,##0") + " sec.";
(Get-Date).ToString("HH:mm:ss") + " --- Finished creating all data files. Duration: $duration`r`n" | Out-File $logFile -Encoding OEM -append;
$logSummary + "Finished creating all data files. Duration: $duration";
