﻿$scriptPath = Split-Path -parent $MyInvocation.MyCommand.Definition; 
. ($scriptPath + "\psFunctions.ps1");     # Adding script with reusable functions
. ($scriptPath + "\psSetVariables.ps1");  # Adding script to assign values to common variables


# ##################################################################
# ########################## Loading Symbol.csv into array to be used later
# ##################################################################
$fn = $psDataFolder + "\Symbol.csv"; $symbolList = import-csv ($psDataFolder + "\Symbol.csv") -Delimiter $colSep | SELECT Symbol;
# ##################################################################

$sl = import-csv ($psDataFolder + "\Quotes.csv") -Delimiter $colSep | SELECT "Symbol" -Unique;
ForEach($s in $sl) { 
    if($symbolList.Where({$_.Symbol -eq $s.Symbol}).count -eq 0) {
        $str = "Symbol '" + $s.Symbol + "' in Quotes.csv but not in Symbol.csv"; 
        Write-Host $str -ForegroundColor Red; $str | Out-File $logFile -Encoding OEM -Append;
    } 
}



# #################################################
# Account
# #################################################

# - Unique values in Account

# - Currency in ReportCurrency table

# #################################################


    #$symbolList.Where({$PSItem.Symbol -eq "SPY2"}).count