# 2024-Apr-16. Created by Maxim T.

$scriptPath = Split-Path -parent $MyInvocation.MyCommand.Definition; 
. ($scriptPath + "\psFunctions.ps1");     # Adding script with reusable functions
. ($scriptPath + "\psSetVariables.ps1");  # Adding script to assign values to common variables

$logFile        = $scriptPath + "\Log\" + $MyInvocation.MyCommand.Name.Replace(".ps1",".txt"); 
(Get-Date).ToString("HH:mm:ss") + " --- Starting script " + $MyInvocation.MyCommand.Name | Out-File $logFile -Encoding OEM; # starting logging to file.
$logSummary = (Get-Date).ToString("HH:mm:ss") + " Script: ExchRate YahooID".PadRight(28);
Get-ChildItem -Path $currExchIDFolder -Filter *Intraday.txt -File | foreach { $_.Delete()}; # Delete existing all files from intraday folder
$currExchIDFile = $currExchIDFolder + "YahooCurrExchIntraday.txt"; #if (Test-Path $currExchIDFile) { Remove-Item $currExchIDFile;} # Removing intraday file before each load
$reqFailed=0; $reqSucceed=0; $reqUsed=0;

$listStart = $config.IndexOf("<Currency>"); $listEnd = $config.IndexOf("</Currency>"); 
if ($listStart -eq -1 -or $listEnd -eq -1 -or $listStart+1 -ge $listEnd) {"<currency> Symbol list is empty. Exiting script." | Out-File $logFile -Encoding OEM -Append; exit(1);}
$currList = @($config | Select-Object -Index(($listStart+1)..($listEnd-1))); #list of symbols we will work on
$currCount= $currList.Count; "Currency count: $currCount. MinDate: $minDate" | Out-File $logFile -Encoding OEM -Append;
if ($currCount -le 1) {"Found just one currency, will not create currency exchange database"; exit(1);}

$urlBase = "https://query1.finance.yahoo.com/v7/finance/download/@@CURRFROM@@@@CURRTO@@=X?period1=@FromDay@&period2=@ToDay@&interval=1d&events=history&crumb=@CRUMB@"
$toDay   = [string] [math]::Floor((get-date -hour 23 -Minute 59 -Second 59 -UFormat %s)); #today in unix timestamp (end of the day)
$fromDay = [string] [math]::Floor((get-Date -hour 0 -Minute 0 -Second 0 -UFormat %s));    #today in unix timestamp (start of the day)
$urlBase = $urlBase.Replace("@FromDay@",$fromDay).Replace("@ToDay@", $toDay);

$logSymbolFolder = $scriptPath + "\Log\SymbolWebpage"; if (!(Test-Path $logSymbolFolder)) {New-Item $logSymbolFolder -type directory}; # setting up folder where text output per currency pair will be temporary stored;

For($currFromIndex=0; $currFromIndex -lt $currCount; $currFromIndex++) {
    For($currToIndex=0; $currToIndex -lt $currCount; $currToIndex++) {
        if ($currList[$currFromIndex] -ne $currList[$currToIndex]) {
            $currFrom=$currList[$currFromIndex]; $currTo = $currList[$currToIndex]; 
            $url = $urlBase.Replace("@@CURRFROM@@",$currFrom).Replace("@@CURRTO@@",$currTo); $currencyPair=$currFrom + "-" + $currTo;
            #$url = $url.Replace("/USD","/"); # if CurrFrom=USD, then remove that (new yahoo requirement 20230118)

            "  Requesting url: " + $url | Out-File $logFile -Encoding OEM -Append; $webpage = ""; $reqRows=0; 
            try {$reqCount++; $wr = Invoke-WebRequest -Uri $url -WebSession $websession; }
            catch { $reqFailed++; "  " + $symbol + " - Not Found (web err) `r`n" | Out-File $logFile -Encoding OEM -Append; continue; } # if attempt to get webpage failed go to next symbol
            if ($wr.StatusCode -ne 200) {$reqFailed++; "  " + $symbol + " - Returned status code: " + $wr.StatusCode + " `r`n" | Out-File $logFile -Encoding OEM -Append; continue;  }

            $quotesTxt = $wr.Content; # This variable now contains downloaded quotes in text format:    Date,Open,High,Low,Close,Adj Close,Volume    |   2017-07-17,78.830002,78.930000,78.760002,78.839996,78.839996,472700

            if ($quotesTxt.length -le 45) { $reqFailed++; "  " + $currencyPair + " - Not Found (return empty file) `r`n" | Out-File $logFile -Encoding OEM -Append; continue;} # Check if data received makes sense. If request size is less than 45 bytes (header length is 42), then there is something wrong with data received. Ignoring it, going to next symbol
            if ($quotesTxt.Contains("<html>")) {$reqFailed++; "  " + $currencyPair + " - Not Found (return html) `r`n" | Out-File $logFile -Encoding OEM -Append; continue;} # Result is html file, ignore such file
            $reqSucceed++; # If reached this point, that means symbol request was successful, go next to copy received data into local file
            # ========== Get quotes from website - End. Quote is in $quotesTxt ==============

            $ret = GetCurrExchInfo $currFrom $currTo $currExchFolder $minDate; $currExchFile = $ret[0]; $nextDate = $ret[1]; $lastQuote = $ret[2];
            "   CurrExch. From: $currFrom -> To: $currTo. Next date: $nextDate. Quote file: $currExchFile" | Out-File $logFile -Encoding OEM -Append;

            $ql = $quotesTxt.Split("`n") | ? {$_.trim() -ne ""  -and ($_.StartsWith("1") -or $_.StartsWith("2"))} | Sort-Object -Descending; # Sometimes duplicate records could come back, need to sort records and not load duplicate values
            if ($ql.Count -ge 2) {$ql=$ql[0];}; #if more than one record come back, just use first record
            $ql | %{$a=$_.Split(","); if($a[0] -ge $nextDate -and $a[0] -gt $lastQuote -and $a[0] -le $todayYMD -and $a[4] -match "^[\d\.]+$") {$a[0]+","+$a[4]+","+$currFrom+","+$currTo; $reqRows++; $lastQuote=$a[0]; } }  |
               Out-File $currExchIDFile -Encoding OEM -Append #taking just date,rate,currencyFrom,currencyTo
            if ($lastQuote -lt $nextDate) {"Done: $currencyPair. No new quotes found. `r`n" | Out-File $logFile -Encoding OEM -Append;} # No new records where loaded
            else {"Done: $currencyPair (from: $nextDate). Record count: $reqRows. Last quote: $lastQuote `r`n" | Out-File $logFile -Encoding OEM -Append; $reqRowsT+=$reqRows;}
        }
    }
}
$fc = Get-Item -Path $currExchIDFile; if ($fc.Length -eq 0) {Remove-Item -Path $currExchIDFile;} # Removing file when size is 0;

$duration = (NEW-TIMESPAN -Start $startTime -End (Get-Date)).TotalSeconds.ToString("#,##0") + " sec.";
(Get-Date).ToString("HH:mm:ss") + " --- Finished. CurrExch Requested/Succeed/Failed/Used: $reqCount/$reqSucceed/$reqFailed/$reqUsed. Duration: $duration. Date-Time: " + $lastDateTime + "`r`n" | Out-File $logFile -Encoding OEM -append;
$logSummary + ". CurrExch Requested/Succeed/Failed/Used: $reqCount/$reqSucceed/$reqFailed/$reqUsed. Date: " + $lastDateTime + ". Duration: $duration";
