# 2018-Jan-16. 
$scriptPath = Split-Path -parent $MyInvocation.MyCommand.Definition; 
. ($scriptPath + "\psFunctions.ps1");     # Adding script with reusable functions
. ($scriptPath + "\psSetVariables.ps1");  # Adding script to assign values to common variables
$logFile        = $scriptPath + "\Log\" + $MyInvocation.MyCommand.Name.Replace(".ps1",".txt"); 
(Get-Date).ToString("HH:mm:ss") + " --- Starting script " + $MyInvocation.MyCommand.Name | Out-File $logFile -Encoding OEM; # starting logging to file.


# #######################################################################################
# ######################## Checking if PowerShell version is at least 3.0
# #######################################################################################
$pShellVersion = $PSVersionTable.PSVersion.Major
if ($pShellVersion -eq $null) {$pShellVersion = 1};
if ($pShellVersion -le 2) {
    "Your PowerShell version is: $pShellVersion and minimum required version is 3.0. You need to upgrade Windows Management Framework to version 3.0+" | Out-File $logFile -Encoding OEM -Append;
    Write-Host "******************************************** ERROR - Wrong PowerShell version! *************************" -ForegroundColor Red
    Write-Host "Your PowerShell version is: $pShellVersion and minimum required version is 3.0." -ForegroundColor Red
    Write-Host "*** ERROR ***. To update PowerShell version you must instal Windows Management Framework 3.0 or later." -ForegroundColor Red
    Write-Host "  Windows Management Framework 3.0: https://www.microsoft.com/en-us/download/details.aspx?id=34595"
    Write-Host "  Windows Management Framework 4.0: https://www.microsoft.com/en-us/download/details.aspx?id=40855"
    Write-Host "  Windows Management Framework 5.0: https://www.microsoft.com/en-us/download/details.aspx?id=50395"
    Write-Host "Waiting for 10sec...";
    Start-Sleep -s 10
}

# #######################################################################################
# ######################## Checking if scripts are up to date
# #######################################################################################
$currentVersion=[System.Version]"3.0.0";
$url = "http://portfolioslicer.com/PSMsg/script3-version.html"; $m = "";
$wc = new-object system.net.WebClient; 
try {
    $webpage = $wc.DownloadData($url); $mhtml = [System.Text.Encoding]::ASCII.GetString($webpage);
    if ($mhtml.IndexOf("<message>") -ge 0) {$m = $mhtml.Substring($mhtml.IndexOf("<message>")+9); if ($m.IndexOf("</message>") -ge 0) {$m = $m.Substring(0, $m.IndexOf("</message>"))}}
}
catch {$m="N/A"; };  
#Write-Host "Your script version: $currentVersion, Online script version is: $m"
"Your script version is: $currentVersion, Online script version is: $m" | Out-File $logFile -Encoding OEM -Append;
if ($m -ne "" -and $m -ne "N/A") { # Compare if current version is older than version in the file
    $onlineVersion = [System.Version]$m;
    if ($onlineVersion -gt $currentVersion) {

        Write-Host "Your script version is: $currentVersion, Online script version is: $m"  -ForegroundColor Red
        Write-Host "`n*** ATTENTION *** New version for PortfolioSlicer external data management scripts available. Download from: http://portfolioslicer.com/download.html`n`n" -ForegroundColor Red
        "You need to update scripts! Your script version is: $currentVersion, Online script version is: $m" | Out-File $logFile -Encoding OEM -Append;
    }
}
# #######################################################################################


