# 2017-Sep-10. Created by Maxim T. 
$scriptPath = Split-Path -parent $MyInvocation.MyCommand.Definition; 
. ($scriptPath + "\psFunctions.ps1");     # Adding script with reusable functions
. ($scriptPath + "\psSetVariables.ps1");  # Adding script to assign values to common variables

$logFile        = $scriptPath + "\Log\" + $MyInvocation.MyCommand.Name.Replace(".ps1",".txt"); 
(Get-Date).ToString("HH:mm:ss") + " --- Starting script " + $MyInvocation.MyCommand.Name | Out-File $logFile -Encoding OEM; # starting logging to file.
$logSummary = (Get-Date).ToString("HH:mm:ss") + " Script: Append GenQ".PadRight(28);
" PSData folder: $psDataFolder" | Out-File $logFile -Encoding OEM -Append;

$includeArchiveFlag = $false; $includeArchiveValue = ($config | Select-Object -Index(($config.IndexOf("<IncludeQuoteArchiveFolder>"))+1)).Replace("</IncludeQuoteArchiveFolder>",""); # Getting IncludeArchive value
if ($includeArchiveValue -ne $null) {if ($includeArchiveValue.Trim().ToLower() -eq "yes") {$includeArchiveFlag = $true;}} 

$outFile = $psDataFolder + "\Quotes.csv";  

$listStart = $config.IndexOf("<GeneratedQuotes>"); $listEnd = $config.IndexOf("</GeneratedQuotes>"); 
if ($listStart -eq -1 -or $listEnd -eq -1 -or $listStart+1 -ge $listEnd) {$symbolCount=0;}
else {$symbolList = @($config | Select-Object -Index(($listStart+1)..($listEnd-1))); $symbolCount = $symbolList.Count;} #list of symbols we will work on
if ($symbolCount -gt 0) {
    # First create list of monthly dates that will be used for generated quotes
    $dToday = Get-Date; $dDate = [datetime]::ParseExact($minDate,"yyyy-MM-dd",$null); $strMthlyDate  = $dDate.ToString("yyyy-MM-dd"); 
    do {
        $dDate = $dDate.AddMonths(1); $dDate = $dDate.AddDays((-1) * $dDate.Day+1);
        if ($dDate.ToString("ddd",$culture) -eq "Sat") {$dDate = $dDate.AddDays(2);}; if ($dDate.ToString("ddd",$culture) -eq "Sun") {$dDate = $dDate.AddDays(1);}; 
        if ($dDate -gt [datetime]::ParseExact($minDate,"yyyy-MM-dd",$null) -and $dDate -le (Get-Date)) {$strMthlyDate+=","+$dDate.ToString("yyyy-MM-dd");}
    } While ($dDate -lt $dToday);

    # Generate quotes for each symbol one per month
    ForEach ($s in $symbolList) {
        $symbolLine = $s.Split(","); $str = ""; $recCount = 0; 
        $symbol = $symbolLine[0]; $minSymbolDate = $symbolLine[1];$maxSymbolDate = $symbolLine[2];  $price = $symbolLine[3];

        if ($minSymbolDate.Trim() -eq "" -or $minSymbolDate -lt $minDate) {$minSymbolDate = $minDate;}
        if ($maxSymbolDate.Trim() -eq "" -or $maxSymbolDate -gt (Get-Date).ToString("yyyy-MM-dd")) {$maxSymbolDate = (Get-Date).ToString("yyyy-MM-dd");} 
        ForEach($d in $strMthlyDate.Split(",")) {
            if($d -ge $minSymbolDate -and $d -le $maxSymbolDate) {$str+=$d + "," + $price + "," + $symbol + "`r`n"; $recCount++; $reqRowsT++;}
        } 
        if ($str.Length -ge 2) {$str = $str.Substring(0, $str.Length-2);}
        if ($str -eq "") {$str = $minSymbolDate + "," + $price + "," + $symbol; $recCount++; $reqRowsT++;}
        if ($colSep -ne ",") {$str = $str.Replace(",", $colSep)}; if ($decSep -ne ".") {$str = $str.Replace(".", $decSep)};
        $str | Out-file $outFile -Encoding OEM -Append;
        " Symbol: $symbol, Generated record count: $recCount" | Out-File $logFile -Encoding OEM -append;
    }
}
else { "** No symbols specified for generated quotes" | Out-File $logFile -Encoding OEM -append;}
# #######################################################################################
$outFile2 = $psDataFolder + "\Quotes2.csv"; if (Test-Path -Path $outFile2) {Remove-Item -path $outFile2};
Rename-Item -Path $outFile -NewName "Quotes2.csv";
(gc $outFile2) | ? {$_.trim() -ne "" } | set-content $outFile  # Removing empty lines from quotes file
if (Test-Path -Path $outFile2) {Remove-Item -path $outFile2};
# #######################################################################################
$duration = (NEW-TIMESPAN -Start $startTime -End (Get-Date)).TotalSeconds.ToString("#,##0") + " sec.";
(Get-Date).ToString("HH:mm:ss") + " --- Finished. GenQuotes SymbolCount/RecCount: $symbolCount/$reqRowsT. Duration: $duration`r`n" | Out-File $logFile -Encoding OEM -append;
$logSummary + ". GenQuotes SymbolCount/RecCount: $symbolCount/$reqRowsT. Duration: $duration";
