# 2018-Sep-07. Created by Maxim T.  
$scriptPath = Split-Path -parent $MyInvocation.MyCommand.Definition; 
. ($scriptPath + "\psFunctions.ps1");     # Adding script with reusable functions
. ($scriptPath + "\psSetVariables.ps1");  # Adding script to assign values to common variables

$logFile        = $scriptPath + "\Log\" + $MyInvocation.MyCommand.Name.Replace(".ps1",".txt"); 
(Get-Date).ToString("HH:mm:ss") + " --- Starting script " + $MyInvocation.MyCommand.Name | Out-File $logFile -Encoding OEM; # starting logging to file.
$logSummary = (Get-Date).ToString("HH:mm:ss") + " Script: ExchRate GoogleID".PadRight(28);
$currExchIDFile = $currExchIDFolder + "GoogleCurrExchIntraday.txt"; if (Test-Path $currExchIDFile) { Remove-Item $currExchIDFile;} # Removing intraday file before each load
Get-ChildItem -Path $currExchIDFolder -Filter *Intraday.txt -File | foreach { $_.Delete()}; # Delete existing all files from intraday folder

$listStart = $config.IndexOf("<Currency>"); $listEnd = $config.IndexOf("</Currency>"); 
if ($listStart -eq -1 -or $listEnd -eq -1 -or $listStart+1 -ge $listEnd) {"<currency> Symbol list is empty. Exiting script." | Out-File $logFile -Encoding OEM -Append; exit(1);}
$currList = @($config | Select-Object -Index(($listStart+1)..($listEnd-1))); #list of symbols we will work on
$currCount= $currList.Count; "Currency count: $currCount. MinDate: $minDate" | Out-File $logFile -Encoding OEM -Append;
if ($currCount -le 1) {"Found just one currency, will not create currency exchange database"; exit(1);}
if (Test-Path ($dataRootFolder + "\QuotesIntraDay\YahooCurrExchIntraday.txt")) { Remove-Item ($dataRootFolder + "\QuotesIntraDay\YahooCurrExchIntraday.txt");} # Prev version location - remove just in case there is leftover file

$urlBase = "https://finance.google.com/finance?q=@@CURRFROM@@@@CURRTO@@"; # Example: https://finance.google.com/finance?q=USDEUR

For($currFromIndex=0; $currFromIndex -lt $currCount; $currFromIndex++) {
    For($currToIndex=0; $currToIndex -lt $currCount; $currToIndex++) {
        if ($currList[$currFromIndex] -ne $currList[$currToIndex]) {
            $currFrom=$currList[$currFromIndex]; $currTo = $currList[$currToIndex]; $url = $urlBase.Replace("@@CURRFROM@@",$currFrom).Replace("@@CURRTO@@",$currTo);
            "  Requesting url: " + $url | Out-File $logFile -Encoding OEM -Append;
            $wc = new-object system.net.WebClient;
            try {$webpage = $wc.DownloadData($url); } # Get page from url. This page will contain all quotes for single Symbol
            catch { $reqFailed++; "  " + $currFrom-$currTo + " - Not Found (web err) `r`n" | Out-File $logFile -Encoding OEM -Append; continue;} # if attempt to get webpage failed go to next symbol
            $str = [System.Text.Encoding]::ASCII.GetString($webpage); # This variable now contains downloaded quotes
    
            $strStart = "content=`""; $strEnd=" />";
            $startStrPrice = "<meta itemprop=`"price`""; $endStrPrice = "/>";
            $startStrDate = "<meta itemprop=`"quoteTime`""; $endStrDate = "/>";
            if (!$str.Contains($startStrPrice) -or !$str.Contains($startStrDate)) {
                $reqFailed++; "  ** For Currency Pair $currFrom-$currTo new quotes not found`r`n" | Out-File $logFile -Encoding OEM -Append;  # if that symbol has no quotes, then record errors
            }
            $strPrice = $str.Substring($str.IndexOf($startStrPrice) + $startStrPrice.Length,100);
            if (!$strPrice.Contains($strStart) -or !$strPrice.Contains(" />")) {$strPrice="";} else {$strPrice=$strPrice.Substring($strPrice.IndexOf($strStart) + $strStart.Length); $strPrice=$strPrice.Substring(0,$strPrice.IndexOf($strEnd)-1);}

            $strDate = $str.Substring($str.IndexOf($startStrDate) + $startStrDate.Length,100);
            if (!$strDate.Contains($strStart) -or !$strDate.Contains(" />")) {$strDate="";} else {$strDate=$strDate.Substring($strDate.IndexOf($strStart) + $strStart.Length); $strDate=$strDate.Substring(0,$strDate.IndexOf($strEnd)-1);}
            if($strDate.Substring(0,2)="20" -and $strDate.Length -gt 10) {$strDate=(Get-Date $strDate).AddHours(-8).ToString("yyyy-MM-dd")};
            $price=$strPrice; $date=$strDate;

            if ($price  -eq "" -or $price  -eq "N/A" -or $price -eq "0" -or $price -eq "0.00") {$reqFailed++; "Something wrong with Price $price" | Out-File $logFile -Encoding OEM -append; continue;} # wrong last price, ignore line
            if ($date.Length -ne 10 -or $date -lt (Get-Date).AddDays(-10).ToString("yyyy-MM-dd") -or $date -gt (Get-Date).ToString("yyyy-MM-dd")) {$reqFailed++; "Something wrong with Date $date" | Out-File $logFile -Encoding OEM -append; continue;} #something wrong with date
    
            try {$dateD = ([datetime]::ParseExact($date,"yyyy-MM-dd",$null)); $dayOfWeek = $dateD.DayOfWeek.ToString();} catch {$dayOfWeek = "Saturday";}
            if ($dayOfWeek -eq "Saturday" -or $dayOfWeek -eq "Sunday") {$weekendFlag = $true} else {$weekendFlag=$false};

            $ret = GetCurrExchInfo $currFrom $currTo $currExchFolder $minDate; $currExchFile = $ret[0]; $nextDate = $ret[1]; $lastQuote = $ret[2];
            "CurrExch. From: $currFrom -> To: $currTo. Next date: $nextDate. Quote file: $currExchFile" | Out-File $logFile -Encoding OEM -Append;
    
            if ($date -ge $nextDate -and (!$weekendFlag)) {
                "$date,$price,$currFrom,$currTo" | Out-File $currExchIDFile -Encoding OEM -append; $reqRowsT++; if("$date $time" -gt $lastDateTime) {$lastDateTime = "$date $time"};
                " New quote date: " + $date + " " + $time | Out-File $logFile -Encoding OEM -append; $reqSucceed++;
            }
            else {" Newer quote not found" | Out-File $logFile -Encoding OEM -append; $reqFailed++;}
        }
    }
}
$duration = (NEW-TIMESPAN -Start $startTime -End (Get-Date)).TotalSeconds.ToString("#,##0") + " sec.";

(Get-Date).ToString("HH:mm:ss") + " --- Finished. CurrExch Requested/Succeed/Failed: $reqCount/$reqSucceed/$reqFailed. Duration: $duration. Date-Time: " + $lastDateTime + "`r`n" | Out-File $logFile -Encoding OEM -append;
$logSummary + ". CurrExch Requested/Succeed/Failed: $reqCount/$reqSucceed/$reqFailed. Date: " + $lastDateTime + ". Duration: $duration";
